/* ///////////////////////////////////////////////////////////////////////// */
/*  This is part of the source of the OMAP 5912 heterogeneous dual-core      */
/*  MPEG-4 SP video decoder published in ACM Transactions on Embedded        */
/*  Computing Systems, Vol. X, Issue Y.                                      */
/* ------------------------------------------------------------------------- */
/*  The source code is released under GPL license.                           */
/*                                                                           */
/*  Copyright, 2011                                                          */
/*  Multimedia Embedded Systems Labs                                         */
/*  Dept. of Computer Science                                                */
/*  National Chiao Tung University                                           */
/*  Hsinchu, Taiwan.                                                         */
/* ///////////////////////////////////////////////////////////////////////// */

#include <stdio.h>
#include <stdlib.h>
#include "metypes.h"
#include "m4vdec_api.h"
#include "dma_api_DSP.h"

extern volatile int flag[6]; /* busy flag for each DMA channel */

void
fun_DMA_1column_y17_x6(DECODER * dec, int x, int y) /* no while  5 4 1 */
{
    dma_port src_obj, dst_obj;
    dma_channel channel_obj;

    src_obj.staddr = (uint32) ((uint32)
    		((uint32) dec->refn.y +
    		 (uint32) ((y << 4) - REF_UP_EDGE) * dec->edged_width -
    		 (uint32) EDGE_SIZE) +
    		 (uint32) (x << 4));  //sy
    src_obj.addressing_frmIndex = (dec->edged_width - 48) * 2 + 1;
    src_obj.addressing_elmIndex = 1;

    dst_obj.staddr = (uint32) (dec->local_refn_start.y); //dy
    //(stride-elecnt)*2+1;
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 4) - 48) * 2 + 1;
    dst_obj.addressing_elmIndex = 1;

    channel_obj.elmCnt = 48;
    channel_obj.frmCnt = 48;
    channel_obj.channel_number = 5;

    while (flag[5] == 0);

    dma_api_sdd_dd(src_obj, dst_obj, channel_obj, 7);

    src_obj.staddr = (uint32)
    		((dec->refn.u + ((y << 3) - (REF_UP_EDGE_2)) * (dec->edged_width >> 1) -
    		 EDGE_SIZE2) + (x << 3)); //su
    src_obj.addressing_frmIndex = ((dec->edged_width >> 1) - 24) * 2 + 1;
    src_obj.addressing_elmIndex = 1;

    dst_obj.staddr = (uint32) (dec->local_refn_start.u);    //du
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - 24) * 2 + 1;
    dst_obj.addressing_elmIndex = 1;

    channel_obj.elmCnt = 24;
    channel_obj.frmCnt = 24;
    channel_obj.channel_number = 4;

    while (flag[4] == 0);

    dma_api_sdd_dd(src_obj, dst_obj, channel_obj, 0);

    src_obj.staddr = (uint32)
    		((dec->refn.v + ((y << 3) - (REF_UP_EDGE_2)) * (dec->edged_width >> 1) -
    		 EDGE_SIZE2) + (x << 3)); //sv
    src_obj.addressing_frmIndex = ((dec->edged_width >> 1) - 24) * 2 + 1;
    src_obj.addressing_elmIndex = 1;

    dst_obj.staddr = (uint32) (dec->local_refn_start.v);    //dv
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - 24) * 2 + 1;
    dst_obj.addressing_elmIndex = 1;

    channel_obj.elmCnt = 24;
    channel_obj.frmCnt = 24;
    channel_obj.channel_number = 1;

    while (flag[1] == 0);

    dma_api_sdd_dd(src_obj, dst_obj, channel_obj, 1);
}

void
fun_DMA_1column_y17_x10(DECODER * dec, int x, int y) /* no while  5 4 1 */
{
    dma_port src_obj, dst_obj;
    dma_channel channel_obj;
    int     z = x % (local_ref_column_size - 2);

    src_obj.staddr = (uint32) (dec->local_refn_start.y + ((2 + z) << 4) - 1);
    src_obj.addressing_frmIndex = (local_ref_column_size << 4) * 2 - 1; //?
    src_obj.addressing_elmIndex = -1;

    dst_obj.staddr = (uint32) (dec->local_refn_start.y + ((2 + z) << 4));   //dy
	//(stride-elecnt)*2+1;
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 4) - 16) * 2 + 1;
    dst_obj.addressing_elmIndex = 1;

    channel_obj.elmCnt = 16;
    channel_obj.frmCnt = 48;
    channel_obj.channel_number = 5;

    while (flag[5] == 0);

    dma_api_dd_dd(src_obj, dst_obj, channel_obj, 7);

    src_obj.staddr = (uint32) (dec->local_refn_start.u + ((2 + z) << 3) - 1);
    src_obj.addressing_frmIndex = (local_ref_column_size << 3) * 2 - 1; //?
    src_obj.addressing_elmIndex = -1;

    dst_obj.staddr = (uint32) (dec->local_refn_start.u + ((2 + z) << 3));   //du
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - 8) * 2 + 1;
    dst_obj.addressing_elmIndex = 1;

    channel_obj.elmCnt = 8;
    channel_obj.frmCnt = 24;
    channel_obj.channel_number = 4;

    while (flag[4] == 0);

    dma_api_dd_dd(src_obj, dst_obj, channel_obj, 0);    //this

    src_obj.staddr = (uint32) (dec->local_refn_start.v + ((2 + z) << 3) - 1);
    src_obj.addressing_frmIndex = (local_ref_column_size << 3) * 2 - 1; //?
    src_obj.addressing_elmIndex = -1;

    dst_obj.staddr = (uint32) (dec->local_refn_start.v + ((2 + z) << 3));   //dv
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - 8) * 2 + 1;
    dst_obj.addressing_elmIndex = 1;

    channel_obj.elmCnt = 8;
    channel_obj.frmCnt = 24;
    channel_obj.channel_number = 1;

    while (flag[1] == 0);

    dma_api_dd_dd(src_obj, dst_obj, channel_obj, 1);
    //while(flag[0]==0||flag[1]==0||flag[2]==0);        
}

void
fun_DMA_1column_y17_xnot610(DECODER * dec, int x, int y) /* no while  5 4 1 */
{
    dma_port src_obj, dst_obj;
    dma_channel channel_obj;
    int     z = x % (local_ref_column_size - 2);

    src_obj.staddr = (uint32) ((uint32) dec->refn.y +
    		(uint32) ((y << 4) - (REF_UP_EDGE)) * dec->edged_width -
    		(uint32) EDGE_SIZE + (uint32) ((2 + x) << 4));   //sy
    src_obj.addressing_frmIndex = (dec->edged_width - 16) * 2 + 1;
    src_obj.addressing_elmIndex = 1;

    dst_obj.staddr = (uint32) (dec->local_refn_start.y + ((2 + z) << 4)); //dy
    //(stride-elecnt)*2+1;
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 4) - 16) * 2 + 1;
    dst_obj.addressing_elmIndex = 1;

    channel_obj.elmCnt = 16;
    channel_obj.frmCnt = 48;
    channel_obj.channel_number = 5;

    while (flag[5] == 0);

    dma_api_sdd_dd(src_obj, dst_obj, channel_obj, 7);

    src_obj.staddr = (uint32) (dec->refn.u +
    				 ((y << 3) - (REF_UP_EDGE_2)) * (dec->edged_width >> 1) -
    				 EDGE_SIZE2 + ((2 + x) << 3)); //su
    src_obj.addressing_frmIndex = ((dec->edged_width >> 1) - 8) * 2 + 1;
    src_obj.addressing_elmIndex = 1;

    dst_obj.staddr = (uint32) (dec->local_refn_start.u + ((2 + z) << 3));   //du
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - 8) * 2 + 1;
    dst_obj.addressing_elmIndex = 1;

    channel_obj.elmCnt = 8;
    channel_obj.frmCnt = 24;
    channel_obj.channel_number = 4;

    while (flag[4] == 0);

    dma_api_sdd_dd(src_obj, dst_obj, channel_obj, 0);   //this

    src_obj.staddr = (uint32) (dec->refn.v +
    					((y << 3) - (REF_UP_EDGE_2)) * (dec->edged_width >> 1) -
    					EDGE_SIZE2 + ((2 + x) << 3)); //sv
    src_obj.addressing_frmIndex = ((dec->edged_width >> 1) - 8) * 2 + 1;
    src_obj.addressing_elmIndex = 1;

    dst_obj.staddr = (uint32) (dec->local_refn_start.v + ((2 + z) << 3));   //dv
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - 8) * 2 + 1;
    dst_obj.addressing_elmIndex = 1;

    channel_obj.elmCnt = 8;
    channel_obj.frmCnt = 24;
    channel_obj.channel_number = 1;

    while (flag[1] == 0);

    dma_api_sdd_dd(src_obj, dst_obj, channel_obj, 1);
}

void
fun_DMA_1column_y0_x10(DECODER * dec, int x, int y) //no while  5 4 1 3 2 0
{
    dma_port src_obj, dst_obj;
    dma_channel channel_obj;
    int     z = x % (local_ref_column_size - 2);    //2008/2/7 07:34U              
    src_obj.staddr =
        (uint32) (dec->local_refn_start.y + ((2 + z) << 4) +
                  16 * (local_ref_column_size << 4) - 1);
    dst_obj.staddr = (uint32) (dec->local_refn_start.y + ((2 + z) << 4));   //dy
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 4) - EDGE_SIZE) * 2 + 1;   //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = EDGE_SIZE;
    channel_obj.frmCnt = EDGE_SIZE;
    channel_obj.channel_number = 5;
    while (flag[5] == 0);
    dma_api_dd_cd(src_obj, dst_obj, channel_obj);

    src_obj.staddr =
        (uint32) (dec->local_refn_start.u + ((2 + z) << 3) +
                  8 * (local_ref_column_size << 3) - 1);
    dst_obj.staddr = (uint32) (dec->local_refn_start.u + ((2 + z) << 3));   //dy
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - EDGE_SIZE2) * 2 + 1;  //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = EDGE_SIZE2;
    channel_obj.frmCnt = EDGE_SIZE2;
    channel_obj.channel_number = 4;
    while (flag[4] == 0);
    dma_api_dd_cd(src_obj, dst_obj, channel_obj);

    src_obj.staddr =
        (uint32) (dec->local_refn_start.v + ((2 + z) << 3) +
                  8 * (local_ref_column_size << 3) - 1);
    dst_obj.staddr = (uint32) (dec->local_refn_start.v + ((2 + z) << 3));   //dy
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - EDGE_SIZE2) * 2 + 1;  //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = EDGE_SIZE2;
    channel_obj.frmCnt = EDGE_SIZE2;
    channel_obj.channel_number = 1;
    while (flag[1] == 0);
    dma_api_dd_cd(src_obj, dst_obj, channel_obj);

    src_obj.staddr =
        (uint32) (dec->local_refn_start.y + ((2 + z) << 4) +
                  16 * (local_ref_column_size << 4) - 1);
    src_obj.addressing_frmIndex = (local_ref_column_size << 4) * 2 - 1; //??
    src_obj.addressing_elmIndex = -1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.y + ((2 + z) << 4) + 16 * (local_ref_column_size << 4));   //dy
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 4) - EDGE_SIZE) * 2 + 1;   //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = EDGE_SIZE;
    channel_obj.frmCnt = 32;
    channel_obj.channel_number = 3;
    while (flag[3] == 0);
    dma_api_dd_dd(src_obj, dst_obj, channel_obj);

    src_obj.staddr =
        (uint32) (dec->local_refn_start.u + ((2 + z) << 3) +
                  8 * (local_ref_column_size << 3) - 1);
    src_obj.addressing_frmIndex = (local_ref_column_size << 3) * 2 - 1; //??
    src_obj.addressing_elmIndex = -1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.u + ((2 + z) << 3) + 8 * (local_ref_column_size << 3));    //dy
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - EDGE_SIZE2) * 2 + 1;  //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = EDGE_SIZE2;
    channel_obj.frmCnt = 16;
    channel_obj.channel_number = 2;
    while (flag[2] == 0);
    dma_api_dd_dd(src_obj, dst_obj, channel_obj);

    src_obj.staddr =
        (uint32) (dec->local_refn_start.v + ((2 + z) << 3) +
                  8 * (local_ref_column_size << 3) - 1);
    src_obj.addressing_frmIndex = (local_ref_column_size << 3) * 2 - 1; //??
    src_obj.addressing_elmIndex = -1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.v + ((2 + z) << 3) + 8 * (local_ref_column_size << 3));    //dy
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - EDGE_SIZE2) * 2 + 1;  //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = EDGE_SIZE2;
    channel_obj.frmCnt = 16;
    channel_obj.channel_number = 0;
    while (flag[0] == 0);
    dma_api_dd_dd(src_obj, dst_obj, channel_obj);
}

void
fun_DMA_1column_y0_x6(DECODER * dec, int x, int y)  //541 while 541
{
    dma_port src_obj, dst_obj;
    dma_channel channel_obj;
    src_obj.staddr = (uint32) ((dec->refn.y + ((y << 4) - (REF_UP_EDGE)) * dec->edged_width - EDGE_SIZE) + (x << 4) + EDGE_SIZE * dec->edged_width);    //sy
    src_obj.addressing_frmIndex = (dec->edged_width - 48) * 2 + 1;
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.y + REF_UP_EDGE * (local_ref_column_size << 4));   //dy
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 4) - 48) * 2 + 1;  //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 48;
    channel_obj.frmCnt = 48 - 16;
    channel_obj.channel_number = 5;
    while (flag[5] == 0);
    dma_api_sdd_dd(src_obj, dst_obj, channel_obj, 7);

    src_obj.staddr = (uint32) ((dec->refn.u + ((y << 3) - (REF_UP_EDGE_2)) * (dec->edged_width >> 1) - EDGE_SIZE2) + (x << 3) + EDGE_SIZE2 * (dec->edged_width >> 1));  //su
    src_obj.addressing_frmIndex = ((dec->edged_width >> 1) - 24) * 2 + 1;
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.u + REF_UP_EDGE_2 * (local_ref_column_size << 3)); //du
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - 24) * 2 + 1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 24;
    channel_obj.frmCnt = 24 - 8;
    channel_obj.channel_number = 4;
    while (flag[4] == 0);
    dma_api_sdd_dd(src_obj, dst_obj, channel_obj, 0);

    src_obj.staddr = (uint32) ((dec->refn.v + ((y << 3) - (REF_UP_EDGE_2)) * (dec->edged_width >> 1) - EDGE_SIZE2) + (x << 3) + EDGE_SIZE2 * (dec->edged_width >> 1));  //sv
    src_obj.addressing_frmIndex = ((dec->edged_width >> 1) - 24) * 2 + 1;
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.v + REF_UP_EDGE_2 * (local_ref_column_size << 3)); //dv
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - 24) * 2 + 1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 24;
    channel_obj.frmCnt = 24 - 8;
    channel_obj.channel_number = 1;
    while (flag[1] == 0);
    dma_api_sdd_dd(src_obj, dst_obj, channel_obj, 1);

    //1x3ɤW                                                                                                   
    src_obj.staddr =
        (uint32) (dec->local_refn_start.y +
                  (REF_UP_EDGE * (local_ref_column_size << 4)));
    src_obj.addressing_frmIndex = (-48) * 2 + 1;
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.y);    //dy
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 4) - 48) * 2 + 1;  //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 48;
    channel_obj.frmCnt = EDGE_SIZE;
    channel_obj.channel_number = 5;
    while (flag[5] == 0);
    dma_api_dd_dd(src_obj, dst_obj, channel_obj, 7);

    src_obj.staddr =
        (uint32) (dec->local_refn_start.u +
                  (REF_UP_EDGE_2 * (local_ref_column_size << 3)));
    src_obj.addressing_frmIndex = (-24) * 2 + 1;
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.u);
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - 24) * 2 + 1;  //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 24;
    channel_obj.frmCnt = EDGE_SIZE2;
    channel_obj.channel_number = 4;
    while (flag[4] == 0);
    dma_api_dd_dd(src_obj, dst_obj, channel_obj, 0);

    src_obj.staddr =
        (uint32) (dec->local_refn_start.v +
                  (REF_UP_EDGE_2 * (local_ref_column_size << 3)));
    src_obj.addressing_frmIndex = (-24) * 2 + 1;
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.v);
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - 24) * 2 + 1;  //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 24;
    channel_obj.frmCnt = EDGE_SIZE2;
    channel_obj.channel_number = 1;
    while (flag[1] == 0);
    dma_api_dd_dd(src_obj, dst_obj, channel_obj, 1);
}

void
fun_DMA_1column_y0_xnot610(DECODER * dec, int x, int y) //541 while 541
{
    dma_port src_obj, dst_obj;
    dma_channel channel_obj;
    int     z = x % (local_ref_column_size - 2);    //2008/1/14 04:31U                                                                                         
    src_obj.staddr = (uint32) (dec->refn.y + ((y << 4) - (REF_UP_EDGE)) * dec->edged_width - EDGE_SIZE + ((2 + x) << 4) + EDGE_SIZE * dec->edged_width);    //sy
    src_obj.addressing_frmIndex = (dec->edged_width - 16) * 2 + 1;
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.y + ((2 + z) << 4) + EDGE_SIZE * (local_ref_column_size << 4));    //dy
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 4) - 16) * 2 + 1;  //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 16;
    channel_obj.frmCnt = 32;
    channel_obj.channel_number = 5;
    while (flag[5] == 0);
    dma_api_sdd_dd(src_obj, dst_obj, channel_obj);
//                  init_timer();
//                      start_timer();                                      
    src_obj.staddr = (uint32) (dec->refn.u + ((y << 3) - (REF_UP_EDGE_2)) * (dec->edged_width >> 1) - EDGE_SIZE2 + ((2 + x) << 3) + EDGE_SIZE2 * (dec->edged_width >> 1));  //su
    src_obj.addressing_frmIndex = ((dec->edged_width >> 1) - 8) * 2 + 1;
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.u + ((2 + z) << 3) + EDGE_SIZE2 * (local_ref_column_size << 3));   //du
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - 8) * 2 + 1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 8;
    channel_obj.frmCnt = 16;
    channel_obj.channel_number = 4;
    while (flag[4] == 0);
    dma_api_sdd_dd(src_obj, dst_obj, channel_obj);  //this

    src_obj.staddr = (uint32) (dec->refn.v + ((y << 3) - (REF_UP_EDGE_2)) * (dec->edged_width >> 1) - EDGE_SIZE2 + ((2 + x) << 3) + EDGE_SIZE2 * (dec->edged_width >> 1));  //sv
    src_obj.addressing_frmIndex = ((dec->edged_width >> 1) - 8) * 2 + 1;
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.v + ((2 + z) << 3) + EDGE_SIZE2 * (local_ref_column_size << 3));   //dv
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - 8) * 2 + 1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 8;
    channel_obj.frmCnt = 16;
    channel_obj.channel_number = 1;
    while (flag[1] == 0);
    dma_api_sdd_dd(src_obj, dst_obj, channel_obj);

    src_obj.staddr =
        (uint32) (dec->local_refn_start.y + ((2 + z) << 4) +
                  16 * (local_ref_column_size << 4));
    src_obj.addressing_frmIndex = (-16) * 2 + 1;
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.y + ((2 + z) << 4));   //dy
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 4) - 16) * 2 + 1;  //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 16;
    channel_obj.frmCnt = REF_UP_EDGE;
    channel_obj.channel_number = 5;
    while (flag[5] == 0);
    dma_api_dd_dd(src_obj, dst_obj, channel_obj);

    src_obj.staddr =
        (uint32) (dec->local_refn_start.u + ((2 + z) << 3) +
                  8 * (local_ref_column_size << 3));
    src_obj.addressing_frmIndex = (-8) * 2 + 1;
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.u + ((2 + z) << 3));
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - 8) * 2 + 1;   //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 8;
    channel_obj.frmCnt = REF_UP_EDGE_2;
    channel_obj.channel_number = 4;
    while (flag[4] == 0);
    dma_api_dd_dd(src_obj, dst_obj, channel_obj);

    src_obj.staddr =
        (uint32) (dec->local_refn_start.v + ((2 + z) << 3) +
                  8 * (local_ref_column_size << 3));
    src_obj.addressing_frmIndex = (-8) * 2 + 1;
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.v + ((2 + z) << 3));
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - 8) * 2 + 1;   //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 8;
    channel_obj.frmCnt = REF_UP_EDGE_2;

    channel_obj.channel_number = 1;
    while (flag[1] == 0);
    dma_api_dd_dd(src_obj, dst_obj, channel_obj);

}

void
fun_DMA_1column_y8_x6(DECODER * dec, int x, int y)  //541 while 541
{
    dma_port src_obj, dst_obj;
    dma_channel channel_obj;
    src_obj.staddr = (uint32) ((uint32) ((uint32) dec->refn.y + (uint32) ((y << 4) - (REF_UP_EDGE)) * dec->edged_width - (uint32) EDGE_SIZE) + (uint32) (x << 4));  //sy
    src_obj.addressing_frmIndex = (dec->edged_width - 48) * 2 + 1;
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.y);    //dy
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 4) - 48) * 2 + 1;  //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 48;
    channel_obj.frmCnt = 48 - 16;
    channel_obj.channel_number = 5;
    while (flag[5] == 0);
    dma_api_sdd_dd(src_obj, dst_obj, channel_obj);

    src_obj.staddr = (uint32) ((dec->refn.u + ((y << 3) - (REF_UP_EDGE_2)) * (dec->edged_width >> 1) - EDGE_SIZE2) + (x << 3)); //su
    src_obj.addressing_frmIndex = ((dec->edged_width >> 1) - 24) * 2 + 1;
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.u);    //du
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - 24) * 2 + 1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 24;
    channel_obj.frmCnt = 24 - 8;
    channel_obj.channel_number = 4;
    while (flag[4] == 0);
    dma_api_sdd_dd(src_obj, dst_obj, channel_obj);

    src_obj.staddr = (uint32) (dec->refn.v + ((y << 3) - (REF_UP_EDGE_2)) * (dec->edged_width >> 1) - EDGE_SIZE2 + (x << 3));   //sv
    src_obj.addressing_frmIndex = ((dec->edged_width >> 1) - 24) * 2 + 1;
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.v);    //dv
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - 24) * 2 + 1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 24;
    channel_obj.frmCnt = 24 - 8;
    channel_obj.channel_number = 1;
    while (flag[1] == 0);
    dma_api_sdd_dd(src_obj, dst_obj, channel_obj);
    //1x3ɤU                                                               
    src_obj.staddr =
        (uint32) (dec->local_refn_start.y + 31 * (local_ref_column_size << 4));
    src_obj.addressing_frmIndex = (-48) * 2 + 1;
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.y + 32 * (local_ref_column_size << 4));    //dy
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 4) - 48) * 2 + 1;  //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 48;
    channel_obj.frmCnt = EDGE_SIZE;
    channel_obj.channel_number = 5;
    while (flag[5] == 0);
    dma_api_dd_dd(src_obj, dst_obj, channel_obj);

    src_obj.staddr =
        (uint32) (dec->local_refn_start.u + 15 * (local_ref_column_size << 3));
    src_obj.addressing_frmIndex = (-24) * 2 + 1;
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr =
        (uint32) (dec->local_refn_start.u + 16 * (local_ref_column_size << 3));
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - 24) * 2 + 1;  //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 24;
    channel_obj.frmCnt = EDGE_SIZE2;
    channel_obj.channel_number = 4;
    while (flag[4] == 0);
    dma_api_dd_dd(src_obj, dst_obj, channel_obj);

    src_obj.staddr =
        (uint32) (dec->local_refn_start.v + 15 * (local_ref_column_size << 3));
    src_obj.addressing_frmIndex = (-24) * 2 + 1;
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr =
        (uint32) (dec->local_refn_start.v + 16 * (local_ref_column_size << 3));
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - 24) * 2 + 1;  //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 24;
    channel_obj.frmCnt = EDGE_SIZE2;
    channel_obj.channel_number = 1;
    while (flag[1] == 0);
    dma_api_dd_dd(src_obj, dst_obj, channel_obj);
}

void
fun_DMA_1column_y8_x10(DECODER * dec, int x, int y) //no while  5 4 1 3 2 0
{
    dma_port src_obj, dst_obj;
    dma_channel channel_obj;

    int     z = x % (local_ref_column_size - 2);    //2008/1/14 04:31pm
    src_obj.staddr =
        (uint32) (dec->local_refn_start.y + ((2 + z) << 4) +
                  32 * (local_ref_column_size << 4) -
                  (local_ref_column_size << 4) - 1);
    dst_obj.staddr = (uint32) (dec->local_refn_start.y + ((2 + z) << 4) + 32 * (local_ref_column_size << 4));   //dy
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 4) - EDGE_SIZE) * 2 + 1;   //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = EDGE_SIZE;
    channel_obj.frmCnt = EDGE_SIZE;
    channel_obj.channel_number = 5;
    while (flag[5] == 0);
    dma_api_dd_cd(src_obj, dst_obj, channel_obj);

    src_obj.staddr =
        (uint32) (dec->local_refn_start.u + ((2 + z) << 3) +
                  16 * (local_ref_column_size << 3) -
                  (local_ref_column_size << 3) - 1);
    dst_obj.staddr = (uint32) (dec->local_refn_start.u + ((2 + z) << 3) + 16 * (local_ref_column_size << 3));   //dy
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - EDGE_SIZE2) * 2 + 1;  //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = EDGE_SIZE2;
    channel_obj.frmCnt = EDGE_SIZE2;
    channel_obj.channel_number = 4;
    while (flag[4] == 0);
    dma_api_dd_cd(src_obj, dst_obj, channel_obj);

    src_obj.staddr =
        (uint32) (dec->local_refn_start.v + ((2 + z) << 3) +
                  16 * (local_ref_column_size << 3) -
                  (local_ref_column_size << 3) - 1);
    dst_obj.staddr = (uint32) (dec->local_refn_start.v + ((2 + z) << 3) + 16 * (local_ref_column_size << 3));   //dy
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - EDGE_SIZE2) * 2 + 1;  //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = EDGE_SIZE2;
    channel_obj.frmCnt = EDGE_SIZE2;
    channel_obj.channel_number = 1;
    while (flag[1] == 0);
    dma_api_dd_cd(src_obj, dst_obj, channel_obj);

    //ɥkW1X2                                               
    src_obj.staddr = (uint32) (dec->local_refn_start.y + ((2 + z) << 4) - 1);
    src_obj.addressing_frmIndex = (local_ref_column_size << 4) * 2 - 1; //??
    src_obj.addressing_elmIndex = -1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.y + ((2 + z) << 4));   //dy
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 4) - EDGE_SIZE) * 2 + 1;   //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = EDGE_SIZE;
    channel_obj.frmCnt = 32;
    channel_obj.channel_number = 3;
    while (flag[3] == 0);
    dma_api_dd_dd(src_obj, dst_obj, channel_obj);

    src_obj.staddr = (uint32) (dec->local_refn_start.u + ((2 + z) << 3) - 1);
    src_obj.addressing_frmIndex = (local_ref_column_size << 3) * 2 - 1; //??
    src_obj.addressing_elmIndex = -1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.u + ((2 + z) << 3));   //dy
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - EDGE_SIZE2) * 2 + 1;  //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = EDGE_SIZE2;
    channel_obj.frmCnt = 16;
    channel_obj.channel_number = 2;
    while (flag[2] == 0);
    dma_api_dd_dd(src_obj, dst_obj, channel_obj);

    src_obj.staddr = (uint32) (dec->local_refn_start.v + ((2 + z) << 3) - 1);
    src_obj.addressing_frmIndex = (local_ref_column_size << 3) * 2 - 1; //??
    src_obj.addressing_elmIndex = -1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.v + ((2 + z) << 3));   //dy
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - EDGE_SIZE2) * 2 + 1;  //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = EDGE_SIZE2;
    channel_obj.frmCnt = 16;
    channel_obj.channel_number = 0;
    while (flag[0] == 0);
    dma_api_dd_dd(src_obj, dst_obj, channel_obj);
}

void
fun_DMA_1column_y8_xnot610(DECODER * dec, int x, int y) //541 while 541
{
    dma_port src_obj, dst_obj;
    dma_channel channel_obj;
    int     z = x % (local_ref_column_size - 2);    //2008/1/14 04:31U
    src_obj.staddr = (uint32) ((uint32) dec->refn.y + (uint32) ((y << 4) - (REF_UP_EDGE)) * dec->edged_width - (uint32) EDGE_SIZE + (uint32) ((2 + x) << 4));   //sy
    src_obj.addressing_frmIndex = (dec->edged_width - 16) * 2 + 1;
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.y + ((2 + z) << 4));   //dy
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 4) - 16) * 2 + 1;  //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 16;
    channel_obj.frmCnt = 32;
    channel_obj.channel_number = 5;
    while (flag[5] == 0);
    dma_api_sdd_dd(src_obj, dst_obj, channel_obj);

    src_obj.staddr = (uint32) (dec->refn.u + ((y << 3) - (REF_UP_EDGE_2)) * (dec->edged_width >> 1) - EDGE_SIZE2 + ((2 + x) << 3)); //su
    src_obj.addressing_frmIndex = ((dec->edged_width >> 1) - 8) * 2 + 1;
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.u + ((2 + z) << 3));   //du
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - 8) * 2 + 1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 8;
    channel_obj.frmCnt = 16;
    channel_obj.channel_number = 4;
    while (flag[4] == 0);
    dma_api_sdd_dd(src_obj, dst_obj, channel_obj);  //this

    src_obj.staddr = (uint32) (dec->refn.v + ((y << 3) - (REF_UP_EDGE_2)) * (dec->edged_width >> 1) - EDGE_SIZE2 + ((2 + x) << 3)); //sv
    src_obj.addressing_frmIndex = ((dec->edged_width >> 1) - 8) * 2 + 1;
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.v + ((2 + z) << 3));   //dv
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - 8) * 2 + 1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 8;
    channel_obj.frmCnt = 16;
    channel_obj.channel_number = 1;
    while (flag[1] == 0);
    dma_api_sdd_dd(src_obj, dst_obj, channel_obj);

    src_obj.staddr =
        (uint32) (dec->local_refn_start.y + ((2 + z) << 4) +
                  32 * (local_ref_column_size << 4) -
                  (local_ref_column_size << 4));
    src_obj.addressing_frmIndex = (-16) * 2 + 1;
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.y + ((2 + z) << 4) + 32 * (local_ref_column_size << 4));   //dy
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 4) - 16) * 2 + 1;  //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 16;
    channel_obj.frmCnt = REF_UP_EDGE;
    channel_obj.channel_number = 5;
    while (flag[5] == 0);
    dma_api_dd_dd(src_obj, dst_obj, channel_obj);

    src_obj.staddr =
        (uint32) (dec->local_refn_start.u + ((2 + z) << 3) +
                  16 * (local_ref_column_size << 3) -
                  (local_ref_column_size << 3));
    src_obj.addressing_frmIndex = (-8) * 2 + 1;
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr =
        (uint32) (dec->local_refn_start.u + ((2 + z) << 3) +
                  16 * (local_ref_column_size << 3));
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - 8) * 2 + 1;   //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 8;
    channel_obj.frmCnt = REF_UP_EDGE_2;
    channel_obj.channel_number = 4;
    while (flag[4] == 0);
    dma_api_dd_dd(src_obj, dst_obj, channel_obj);

    src_obj.staddr =
        (uint32) (dec->local_refn_start.v + ((2 + z) << 3) +
                  16 * (local_ref_column_size << 3) -
                  (local_ref_column_size << 3));
    src_obj.addressing_frmIndex = (-8) * 2 + 1;
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr =
        (uint32) (dec->local_refn_start.v + ((2 + z) << 3) +
                  16 * (local_ref_column_size << 3));
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - 8) * 2 + 1;   //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 8;
    channel_obj.frmCnt = REF_UP_EDGE_2;
    channel_obj.channel_number = 1;
    while (flag[1] == 0);
    dma_api_dd_dd(src_obj, dst_obj, channel_obj);
}

void
fun_DMA_3column_8(DECODER * dec, int y)
{
    dma_port src_obj, dst_obj;
    dma_channel channel_obj;
    //kW4x4 //direct copy from y==0                 
    src_obj.staddr = (uint32) ((uint32) dec->refn.y + (uint32) ((uint32) ((y << 4) - (REF_UP_EDGE)) * dec->edged_width));   //sy //remove -EDGE_SIZE
    src_obj.addressing_frmIndex = (dec->edged_width - 32) * 2 + 1;  //48 to 32
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.y + EDGE_SIZE);    //dy //+EDGE_SIZE
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 4) - 32) * 2 + 1;  //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 32;    //48 to 32
    channel_obj.frmCnt = 32;
    while (flag[3] == 0);
    channel_obj.channel_number = 3;
    dma_api_sdd_dd(src_obj, dst_obj, channel_obj, 7);

    src_obj.staddr = (uint32) (dec->refn.u + ((y << 3) - (REF_UP_EDGE_2)) * (dec->edged_width >> 1));   //su //remove -EDGE_SIZE2
    src_obj.addressing_frmIndex = ((dec->edged_width >> 1) - 16) * 2 + 1;
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.u + EDGE_SIZE2);   //du //+EDGE_SIZE2
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - 16) * 2 + 1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 16;
    channel_obj.frmCnt = 16;
    channel_obj.channel_number = 2;
    while (flag[2] == 0);
    dma_api_sdd_dd(src_obj, dst_obj, channel_obj, 0);

    src_obj.staddr = (uint32) (dec->refn.v + ((y << 3) - (REF_UP_EDGE_2)) * (dec->edged_width >> 1));   //sv //remove -EDGE_SIZE2
    src_obj.addressing_frmIndex = ((dec->edged_width >> 1) - 16) * 2 + 1;
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.v + EDGE_SIZE2);   //dv//+EDGE_SIZE2
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - 16) * 2 + 1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 16;
    channel_obj.frmCnt = 16;
    channel_obj.channel_number = 0;
    while (flag[0] == 0);
    dma_api_sdd_dd(src_obj, dst_obj, channel_obj, 1);
    //while(flag[1]==0||flag[4]==0||flag[5]==0);
    //U1x1   
    src_obj.staddr =
        (uint32) (dec->local_refn_start.y + EDGE_SIZE +
                  (32 - 1) * (local_ref_column_size << 4));
    dst_obj.staddr = (uint32) (dec->local_refn_start.y + 32 * (local_ref_column_size << 4));    //dy
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 4) - EDGE_SIZE) * 2 + 1;   //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = EDGE_SIZE;
    channel_obj.frmCnt = EDGE_SIZE;
    channel_obj.channel_number = 3;
    while (flag[3] == 0);
    dma_api_dd_cd(src_obj, dst_obj, channel_obj, 7);

    src_obj.staddr =
        (uint32) (dec->local_refn_start.u + EDGE_SIZE2 +
                  (16 - 1) * (local_ref_column_size << 3));
    dst_obj.staddr = (uint32) (dec->local_refn_start.u + 16 * (local_ref_column_size << 3));    //dy
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - EDGE_SIZE2) * 2 + 1;  //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = EDGE_SIZE2;
    channel_obj.frmCnt = EDGE_SIZE2;
    channel_obj.channel_number = 2;
    while (flag[2] == 0);
    dma_api_dd_cd(src_obj, dst_obj, channel_obj, 0);

    src_obj.staddr =
        (uint32) (dec->local_refn_start.v + EDGE_SIZE2 +
                  (16 - 1) * (local_ref_column_size << 3));
    dst_obj.staddr = (uint32) (dec->local_refn_start.v + 16 * (local_ref_column_size << 3));    //dy
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - EDGE_SIZE2) * 2 + 1;  //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = EDGE_SIZE2;
    channel_obj.frmCnt = EDGE_SIZE2;
    channel_obj.channel_number = 0;
    while (flag[0] == 0);
    dma_api_dd_cd(src_obj, dst_obj, channel_obj, 1);
    //U2x1
    src_obj.staddr =
        (uint32) (dec->local_refn_start.y + EDGE_SIZE +
                  31 * (local_ref_column_size << 4));
    src_obj.addressing_frmIndex = (-32) * 2 + 1;
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.y + EDGE_SIZE + 32 * (local_ref_column_size << 4));    //dy
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 4) - 32) * 2 + 1;  //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 32;
    channel_obj.frmCnt = EDGE_SIZE;
    channel_obj.channel_number = 5;
    while (flag[5] == 0);
    dma_api_dd_dd(src_obj, dst_obj, channel_obj, 7);

    src_obj.staddr =
        (uint32) (dec->local_refn_start.u + EDGE_SIZE2 +
                  15 * (local_ref_column_size << 3));
    src_obj.addressing_frmIndex = (-16) * 2 + 1;
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr =
        (uint32) (dec->local_refn_start.u + EDGE_SIZE2 +
                  16 * (local_ref_column_size << 3));
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - 16) * 2 + 1;  //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 16;
    channel_obj.frmCnt = EDGE_SIZE2;
    channel_obj.channel_number = 4;
    while (flag[4] == 0);
    dma_api_dd_dd(src_obj, dst_obj, channel_obj, 0);

    src_obj.staddr =
        (uint32) (dec->local_refn_start.v + EDGE_SIZE2 +
                  15 * (local_ref_column_size << 3));
    src_obj.addressing_frmIndex = (-16) * 2 + 1;
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr =
        (uint32) (dec->local_refn_start.v + EDGE_SIZE2 +
                  16 * (local_ref_column_size << 3));
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - 16) * 2 + 1;  //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 16;
    channel_obj.frmCnt = EDGE_SIZE2;
    channel_obj.channel_number = 1;
    while (flag[1] == 0);
    dma_api_dd_dd(src_obj, dst_obj, channel_obj, 1);
    //while(flag[1]==0||flag[4]==0||flag[5]==0);                                                                                        
    //1x2
    src_obj.staddr = (uint32) (dec->local_refn_start.y + EDGE_SIZE);
    src_obj.addressing_frmIndex = (local_ref_column_size << 4) * 2 - 1; //??
    src_obj.addressing_elmIndex = -1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.y);    //dy
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 4) - EDGE_SIZE) * 2 + 1;   //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = EDGE_SIZE;
    channel_obj.frmCnt = 32;
    channel_obj.channel_number = 3;
    while (flag[3] == 0);
    dma_api_dd_dd(src_obj, dst_obj, channel_obj, 7);

    src_obj.staddr = (uint32) (dec->local_refn_start.u + EDGE_SIZE2);
    src_obj.addressing_frmIndex = (local_ref_column_size << 3) * 2 - 1; //??
    src_obj.addressing_elmIndex = -1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.u);    //dy
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - EDGE_SIZE2) * 2 + 1;  //??
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = EDGE_SIZE2;
    channel_obj.frmCnt = 16;
    channel_obj.channel_number = 2;
    while (flag[2] == 0);
    dma_api_dd_dd(src_obj, dst_obj, channel_obj, 0);

    src_obj.staddr = (uint32) (dec->local_refn_start.v + EDGE_SIZE2);
    src_obj.addressing_frmIndex = (local_ref_column_size << 3) * 2 - 1; //??
    src_obj.addressing_elmIndex = -1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.v);    //dy
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - EDGE_SIZE2) * 2 + 1;  //??
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = EDGE_SIZE2;
    channel_obj.frmCnt = 16;
    channel_obj.channel_number = 0;
    while (flag[0] == 0);
    dma_api_dd_dd(src_obj, dst_obj, channel_obj, 1);
}

void
fun_DMA_3column_not08(DECODER * dec, int y)
{
    dma_port src_obj, dst_obj;
    dma_channel channel_obj;
    //kcolumn                        
    src_obj.staddr = (uint32) ((uint32) dec->refn.y + (uint32) ((uint32) ((y << 4) - (REF_UP_EDGE)) * dec->edged_width));   //sy //remove -EDGE_SIZE
    src_obj.addressing_frmIndex = (dec->edged_width - 32) * 2 + 1;  //48 to 32
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.y + EDGE_SIZE);    //dy //+EDGE_SIZE
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 4) - 32) * 2 + 1;  //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 32;    //48 to 32
    channel_obj.frmCnt = 48;
    channel_obj.channel_number = 3;
    while (flag[3] == 0);
    dma_api_sdd_dd(src_obj, dst_obj, channel_obj, 7);

    src_obj.staddr = (uint32) (dec->refn.u + ((y << 3) - (REF_UP_EDGE_2)) * (dec->edged_width >> 1));   //su //remove -EDGE_SIZE2
    src_obj.addressing_frmIndex = ((dec->edged_width >> 1) - 16) * 2 + 1;
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.u + EDGE_SIZE2);   //du //+EDGE_SIZE2
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - 16) * 2 + 1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 16;
    channel_obj.frmCnt = 24;
    channel_obj.channel_number = 2;
    while (flag[2] == 0);
    dma_api_sdd_dd(src_obj, dst_obj, channel_obj, 0);

    src_obj.staddr = (uint32) (dec->refn.v + ((y << 3) - (REF_UP_EDGE_2)) * (dec->edged_width >> 1));   //sv //remove -EDGE_SIZE2
    src_obj.addressing_frmIndex = ((dec->edged_width >> 1) - 16) * 2 + 1;
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.v + EDGE_SIZE2);   //dv//+EDGE_SIZE2
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - 16) * 2 + 1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 16;
    channel_obj.frmCnt = 24;
    channel_obj.channel_number = 0;
    while (flag[0] == 0);
    dma_api_sdd_dd(src_obj, dst_obj, channel_obj, 1);
    //@column                                                                    
    src_obj.staddr = (uint32) (dec->local_refn_start.y + EDGE_SIZE);    //sy
    src_obj.addressing_frmIndex = (local_ref_column_size << 4) * 2 - 1; //??
    src_obj.addressing_elmIndex = -1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.y);    //dy 
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 4) - 16) * 2 + 1;  //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 16;    //
    channel_obj.frmCnt = 48;
    channel_obj.channel_number = 3;
    //while(flag[1]==0||flag[4]==0||flag[5]==0); 
    while (flag[3] == 0);
    dma_api_dd_dd(src_obj, dst_obj, channel_obj, 7);

    src_obj.staddr = (uint32) (dec->local_refn_start.u + EDGE_SIZE2);   //su 
    src_obj.addressing_frmIndex = (local_ref_column_size << 3) * 2 - 1; //??
    src_obj.addressing_elmIndex = -1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.u);    //du 
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - 8) * 2 + 1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 8;
    channel_obj.frmCnt = 24;
    channel_obj.channel_number = 2;
    while (flag[2] == 0);
    dma_api_dd_dd(src_obj, dst_obj, channel_obj, 0);

    src_obj.staddr = (uint32) (dec->local_refn_start.v + EDGE_SIZE2);   //sv 
    src_obj.addressing_frmIndex = (local_ref_column_size << 3) * 2 - 1; //??
    src_obj.addressing_elmIndex = -1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.v);    //dv
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - 8) * 2 + 1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 8;
    channel_obj.frmCnt = 24;
    channel_obj.channel_number = 0;
    while (flag[0] == 0);
    dma_api_dd_dd(src_obj, dst_obj, channel_obj, 1);
}

void
fun_DMA_3column_0(DECODER * dec, int y)
{
    dma_port src_obj, dst_obj;
    dma_channel channel_obj;

    //kU4x4   
    src_obj.staddr = (uint32) (dec->refn.y + ((y << 4) - (REF_UP_EDGE) + EDGE_SIZE) * dec->edged_width);    //sy //remove -EDGE_SIZE
    src_obj.addressing_frmIndex = (dec->edged_width - 32) * 2 + 1;  //48 to 32
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.y + EDGE_SIZE + (local_ref_column_size << 4) * EDGE_SIZE); //dy //+EDGE_SIZE
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 4) - 32) * 2 + 1;  //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 32;    //48 to 32
    channel_obj.frmCnt = 32;
    channel_obj.channel_number = 5;
    while (flag[5] == 0);
    dma_api_sdd_dd(src_obj, dst_obj, channel_obj, 7);

    src_obj.staddr = (uint32) (dec->refn.u + ((y << 3) - (REF_UP_EDGE_2) + EDGE_SIZE2) * (dec->edged_width >> 1));  //su //remove -EDGE_SIZE2
    src_obj.addressing_frmIndex = ((dec->edged_width >> 1) - 16) * 2 + 1;
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.u + EDGE_SIZE2 + (local_ref_column_size << 3) * EDGE_SIZE2);   //du //+EDGE_SIZE2
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - 16) * 2 + 1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 16;
    channel_obj.frmCnt = 16;
    channel_obj.channel_number = 4;
    while (flag[4] == 0);
    dma_api_sdd_dd(src_obj, dst_obj, channel_obj, 0);

    src_obj.staddr = (uint32) (dec->refn.v + ((y << 3) - (REF_UP_EDGE_2) + EDGE_SIZE2) * (dec->edged_width >> 1));  //sv //remove -EDGE_SIZE2
    src_obj.addressing_frmIndex = ((dec->edged_width >> 1) - 16) * 2 + 1;
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.v + EDGE_SIZE2 + (local_ref_column_size << 3) * EDGE_SIZE2);   //dv//+EDGE_SIZE2
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - 16) * 2 + 1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 16;
    channel_obj.frmCnt = 16;
    channel_obj.channel_number = 1;
    while (flag[1] == 0);
    dma_api_sdd_dd(src_obj, dst_obj, channel_obj, 1);

    //W1x1
    src_obj.staddr =
        (uint32) (dec->local_refn_start.y + EDGE_SIZE +
                  EDGE_SIZE * (local_ref_column_size << 4));
    dst_obj.staddr = (uint32) (dec->local_refn_start.y);    //dy
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 4) - EDGE_SIZE) * 2 + 1;   //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = EDGE_SIZE;
    channel_obj.frmCnt = EDGE_SIZE;
    channel_obj.channel_number = 5;
    while (flag[5] == 0);
    dma_api_dd_cd(src_obj, dst_obj, channel_obj, 7);

    src_obj.staddr =
        (uint32) (dec->local_refn_start.u + EDGE_SIZE2 +
                  EDGE_SIZE2 * (local_ref_column_size << 3));
    dst_obj.staddr = (uint32) (dec->local_refn_start.u);    //dy
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - EDGE_SIZE2) * 2 + 1;  //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = EDGE_SIZE2;
    channel_obj.frmCnt = EDGE_SIZE2;
    channel_obj.channel_number = 4;
    while (flag[4] == 0);
    dma_api_dd_cd(src_obj, dst_obj, channel_obj, 0);

    src_obj.staddr =
        (uint32) (dec->local_refn_start.u + EDGE_SIZE2 +
                  EDGE_SIZE2 * (local_ref_column_size << 3));
    dst_obj.staddr = (uint32) (dec->local_refn_start.v);    //dy
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - EDGE_SIZE2) * 2 + 1;  //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = EDGE_SIZE2;
    channel_obj.frmCnt = EDGE_SIZE2;
    channel_obj.channel_number = 1;
    while (flag[1] == 0);
    dma_api_dd_cd(src_obj, dst_obj, channel_obj, 1);
    //W2x1
    src_obj.staddr =
        (uint32) (dec->local_refn_start.y + EDGE_SIZE +
                  EDGE_SIZE * (local_ref_column_size << 4));
    src_obj.addressing_frmIndex = (-32) * 2 + 1;
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.y + EDGE_SIZE);    //dy
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 4) - 32) * 2 + 1;  //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 32;
    channel_obj.frmCnt = EDGE_SIZE;
    channel_obj.channel_number = 3;
    while (flag[3] == 0);
    dma_api_dd_dd(src_obj, dst_obj, channel_obj, 7);

    src_obj.staddr =
        (uint32) (dec->local_refn_start.u + EDGE_SIZE2 +
                  EDGE_SIZE2 * (local_ref_column_size << 3));
    src_obj.addressing_frmIndex = (-16) * 2 + 1;
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.u + EDGE_SIZE2);
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - 16) * 2 + 1;  //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 16;
    channel_obj.frmCnt = EDGE_SIZE2;
    channel_obj.channel_number = 2;
    while (flag[2] == 0);
    dma_api_dd_dd(src_obj, dst_obj, channel_obj, 0);

    src_obj.staddr =
        (uint32) (dec->local_refn_start.v + EDGE_SIZE2 +
                  EDGE_SIZE2 * (local_ref_column_size << 3));
    src_obj.addressing_frmIndex = (-16) * 2 + 1;
    src_obj.addressing_elmIndex = 1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.v + EDGE_SIZE2);
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - 16) * 2 + 1;  //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = 16;
    channel_obj.frmCnt = EDGE_SIZE2;
    channel_obj.channel_number = 0;
    while (flag[0] == 0);
    dma_api_dd_dd(src_obj, dst_obj, channel_obj, 1);
    //1x2
    src_obj.staddr =
        (uint32) (dec->local_refn_start.y +
                  EDGE_SIZE * (local_ref_column_size << 4) + EDGE_SIZE);
    src_obj.addressing_frmIndex = (local_ref_column_size << 4) * 2 - 1; //??
    src_obj.addressing_elmIndex = -1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.y + EDGE_SIZE * (local_ref_column_size << 4)); //dy
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 4) - EDGE_SIZE) * 2 + 1;   //(stride-elecnt)*2+1;
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = EDGE_SIZE;
    channel_obj.frmCnt = 32;
    channel_obj.channel_number = 5;
    //while(flag[1]==0||flag[4]==0||flag[5]==0);
    while (flag[5] == 0);
    dma_api_dd_dd(src_obj, dst_obj, channel_obj, 7);

    src_obj.staddr =
        (uint32) (dec->local_refn_start.u +
                  EDGE_SIZE2 * (local_ref_column_size << 3) + EDGE_SIZE2);
    src_obj.addressing_frmIndex = (local_ref_column_size << 3) * 2 - 1; //??
    src_obj.addressing_elmIndex = -1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.u + EDGE_SIZE2 * (local_ref_column_size << 3));    //dy
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - EDGE_SIZE2) * 2 + 1;  //??
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = EDGE_SIZE2;
    channel_obj.frmCnt = 16;
    channel_obj.channel_number = 4;
    while (flag[4] == 0);
    dma_api_dd_dd(src_obj, dst_obj, channel_obj, 0);

    src_obj.staddr =
        (uint32) (dec->local_refn_start.v +
                  EDGE_SIZE2 * (local_ref_column_size << 3) + EDGE_SIZE2);
    src_obj.addressing_frmIndex = (local_ref_column_size << 3) * 2 - 1; //??
    src_obj.addressing_elmIndex = -1;
    dst_obj.staddr = (uint32) (dec->local_refn_start.v + EDGE_SIZE2 * (local_ref_column_size << 3));    //dy
    dst_obj.addressing_frmIndex = ((local_ref_column_size << 3) - EDGE_SIZE2) * 2 + 1;  //??
    dst_obj.addressing_elmIndex = 1;
    channel_obj.elmCnt = EDGE_SIZE2;
    channel_obj.frmCnt = 16;
    channel_obj.channel_number = 1;
    while (flag[1] == 0);
    dma_api_dd_dd(src_obj, dst_obj, channel_obj, 1);
}
